import ssl
ssl._create_default_https_context = ssl._create_unverified_context
import os
import certifi
os.environ['SSL_CERT_FILE'] = certifi.where()
import subprocess
import sys
import time
import threading
import logging
from datetime import datetime

# Configure logging to prevent duplicate messages
logging.basicConfig(level=logging.WARNING)

class PaymentProcessor:
    def __init__(self):
        self.running = False
        
    def check_payments(self):
        """Run the payment processing script"""
        while self.running:
            current_time = None  # Initialize current_time outside the try block
            try:
                current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                print(f"[{current_time}] 💳 Checking for payments...")
                
                # Run the payment processor
                result = subprocess.run([sys.executable, "cav_integrated.py"], 
                                      capture_output=True, text=True, timeout=300)
                
                # Check if any orders were processed
                if "REAL ACCOUNTS CREATED:" in result.stdout:
                    # Extract the success count
                    for line in result.stdout.split('\n'):
                        if "REAL ACCOUNTS CREATED:" in line:
                            print(f"[{current_time}] 🎉 {line.split('INFO:')[-1].strip()}")
                            break
                elif "SUCCESS: Order #" in result.stdout:
                    # Count individual successes
                    success_count = result.stdout.count("SUCCESS: Order #")
                    print(f"[{current_time}] 🎉 {success_count} payment(s) processed successfully!")
                else:
                    print(f"[{current_time}] ✅ Payment check completed - no new payments")
                
                # Log any errors
                if result.stderr:
                    print(f"[{current_time}] ⚠️ Payment check warning: {result.stderr}")
                    
            except subprocess.TimeoutExpired:
                if current_time:
                    print(f"[{current_time}] ⚠️ Payment check timed out")
                else:
                    print("⚠️ Payment check timed out (time unavailable)")
            except Exception as e:
                if current_time:
                    print(f"[{current_time}] ❌ Payment check error: {e}")
                else:
                    print(f"❌ Payment check error: {e} (time unavailable)")
            
            # Wait 2 minutes
            time.sleep(120)
    
    def start(self):
        """Start the payment processor"""
        self.running = True
        self.thread = threading.Thread(target=self.check_payments)
        self.thread.daemon = True
        self.thread.start()
        
    def stop(self):
        """Stop the payment processor"""
        self.running = False

def main():
    print("[{}] 🚀 Service Management System Starting...".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    
    # Start Telegram bot
    print("[{}] 🤖 Starting Telegram bot...".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    try:
        bot_process = subprocess.Popen([sys.executable, "bot.py"])
        print("[{}] ✅ Telegram bot started successfully".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    except Exception as e:
        print(f"[{datetime.now().strftime('%Y-%m-%d %H:%M:%S')}] ❌ Failed to start Telegram bot: {e}")
        return
    
    # Start payment processor
    payment_processor = PaymentProcessor()
    payment_processor.start()
    print("[{}] 💳 Payment checker started (every 120 seconds)".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    
    print("[{}] ✅ System started successfully!".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    print("[{}] 📊 System Status:".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    print("[{}]    🤖 Telegram Bot: Running".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    print("[{}]    💳 Payment Checker: Running".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    print("[{}]    ⏰ Check Interval: 2 minutes".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    print("[{}] ".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    print("[{}] Press Ctrl+C to stop the system".format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    
    try:
        while True:
            time.sleep(1)
    except KeyboardInterrupt:
        print(f"[{datetime.now().strftime('%Y-%m-%d %H:%M:%S')}] 🛑 Shutting down system...")
        payment_processor.stop()
        bot_process.terminate()
        bot_process.wait()
        print(f"[{datetime.now().strftime('%Y-%m-%d %H:%M:%S')}] ✅ System shutdown complete")

if __name__ == "__main__":
    main()